/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.ArgParser;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyFloat;
import org.python.core.PyObject;

class RoundFunction
extends PyBuiltinFunction {
    RoundFunction() {
        super("round", "round(number[, ndigits]) -> floating point number\n\nRound a number to a given precision in decimal digits (default 0 digits).\nThis always returns a floating point number.  Precision may be negative.");
    }

    public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = new ArgParser("round", pyObjectArray, stringArray, new String[]{"number", "ndigits"}, 0);
        PyObject pyObject = argParser.getPyObject(0);
        int n = argParser.getInt(1, 0);
        return RoundFunction.round(pyObject.asDouble(), n);
    }

    private static PyFloat round(double d, int n) {
        boolean bl = d < 0.0;
        double d2 = Math.pow(10.0, n);
        if (bl) {
            d = -d;
        }
        double d3 = Math.floor(d * d2 + 0.5);
        if (bl) {
            d3 = -d3;
        }
        return new PyFloat(d3 / d2);
    }
}

